#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Psychedelic Bright Wired StarMod01.fsh  by  timmaffett   
//https://www.shadertoy.com/view/M3V3Rd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Fork of "DarkStar" by duo. https://shadertoy.com/view/43y3zd
// 2024-06-11 14:12:06

// Fork of "Wired" by kishimisu. https://shadertoy.com/view/4c2XDc
// 2024-06-11 14:09:12

/* "Wired" by @kishimisu (2024) - https://www.shadertoy.com/view/4c2XDc

   I wonder what it's powering...

   This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 
   International License       (https://creativecommons.org/licenses/by-nc-sa/4.0/deed.en)
*/


// customizable color from @WhiteTophat  in https://www.shadertoy.com/view/dlBczW
vec4 lerp(vec4 a, vec4 b, float t) {
    return (a * vec4(t)) + (b * vec4(1.0-t));
}
vec4 lerp(vec4 a, vec4 b, vec4 t) {
    return (a * t) + (b * (vec4(1.0) * t));
}

vec4 hue2rgb(float hue) {
    hue = fract(hue); //only use fractional part of hue, making it loop
    float r = abs(hue * 6.0 - 3.0) - 1.0; //red
    float g = 2.0 - abs(hue * 6.0 - 2.0); //green
    float b = 2.0 - abs(hue * 6.0 - 4.0); //blue
    vec4 rgb = vec4(r,g,b, 1.0); //combine components
    rgb = clamp(rgb, 0.0, 1.0); //clamp between 0 and 1
    return rgb;
}
vec4 hsv2rgb(vec3 hsv) {
    vec4 rgb = hue2rgb(hsv.x); //apply hue
    rgb = lerp(vec4(1.0), rgb, 1.0 - hsv.y); //apply saturation
    rgb = rgb * hsv.z; //apply value
    return rgb;
}
 

#define r(a) mat2 (cos(a + vec4(0,33, 11,0)));
#define R(p, T) p.yx *= r(round((atan(p.y, p.x) + T) * 1.91) / 1.91 - T)
#define O fragColor
#define F fragCoord

//void mainImage(out vec4 O, vec2 F) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

    float i, t = 0.0, d, k = iTime / 8.0;


vec2 mouseUV = iMouse.xy==vec2(0.) ? vec2(0.1,0.9) : iMouse.xy / iResolution.xy;

    O = vec4(0.0);
    vec2 R = iResolution.xy;
    vec3 p;

    for (i = 0.0; i < 30.0; i++) {
        p = vec3(F + F - R, R.y);
        p = normalize(p) * t;
        p.z -= 3.0;
        p.xz *= r(k + 0.1);
        p.zy *= r(k + k);
        d = length(p)- sin(k + k) * .5 - 0.4;

        p.y += sin(p.x * cos(k + k) + k * 4.0) * sin(k) * 0.3;
        R(p.xy, 0.0);
        R(p.xz, k);
        p.x = mod(p.x + k * 8.0, 2.0) - 1.0;
        t += d = min(d, length(p.yz) - 0.03) * 0.5;

        O += 0.01 * (cos(t - k + vec4(0, 1, 3, 0))) / (length(p) - 0.02) + (0.025 + sin(k) * 0.01) / (0.8 + d * 24.0);
    }

    fragColor = fract(O+ hsv2rgb(p+t*sin(iTime)*(mouseUV.x/sin(mouseUV.y))) +(iTime/10.));

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

